/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

float f(vec2 p)
{
	float v = 0.0;	
	float n = 0.0;
	
	for(int i = 0;i < 20;i++)
	{
		v += sin(p.x*n+time)*sin(p.y*n);
		n++;
	}
	
	return v;	
}

vec2 df(vec2 p)
{
	vec2 h = vec2(0.01,0);
	return vec2(f(p+h.xy) - f(p-h.xy),f(p+h.yx) - f(p-h.yx))/h.x;
}

void main( void ) {

	vec2 res = vec2(resolution.x/resolution.y,1);
	vec2 p = ( scaled_gl_FragCoord.xy / resolution.y ) - res/2.0;
	p *= 8.0;

	float c = 0.0;
	
	c = abs(f(p))/length(df(p));
	
	c = smoothstep(0.000,8.0/resolution.x,c);
	gl_FragColor = vec4( vec3( c ), 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}